$(document).ready(function()
{
    var app_sw = new AppSW()
    app_sw.show_status()
})

function AppSW () {
    var button_command_xhr = new XMLHttpRequest();
    var get_status_xhr = new XMLHttpRequest();

    this.show_status = function(){
        var query = '/get_od_data.form?';
	    query += `0x5001_1`; //status

        get_status_xhr.open('GET', query, true);
        get_status_xhr.send();
    }

    function form_tag_tr_param_class(param) //param.name, param.index, param.sub
    {
        var td = $('<td>').addClass('name').text(param.name)
        var tr = $('<tr class="can_hide">').append(td)//.addClass("name"));
        var div = $('<div>').addClass("tag").attr({"index": `${param.index.toString(16).toUpperCase()}:${param.sub}`});
        tr.append($('<td>').append(div))//.addClass("name"));
        return tr;
    }

    function status_ready()
    {
        var values = get_response_values(get_status_xhr)
        var status = values[0]
        console.log(status)

        if (status != 255)
        {
            var h3 = '<h3 id="UserApp">Application SW</h3>'
            var description_header = '<div class="accordion-header">Application SW Description</div>'
            var description_body = $('<div>').addClass("accordion-body")
            var table = $('<table>')
            table.append(form_tag_tr_param_class({name: 'Project Name', index: 0x5000, sub: 1}))
            table.append(form_tag_tr_param_class({name: 'Project Build Date', index: 0x5000, sub: 2}))
            table.append(form_tag_tr_param_class({name: 'Project Version', index: 0x5000, sub: 3}))
            table.append(form_tag_tr_param_class({name: 'Checksum', index: 0x5000, sub: 4}))
            description_body.append(table)
            $("#app_sw_div").append(h3).append(description_header).append(description_body)
            //$("#app_sw_div").load("app_sw.html")

            var control_header = '<div class="accordion-header">Application SW Control</div>'
            var control_body = $('<div>').addClass("accordion-body")
            var table = $('<table>')
            table.append(form_tag_tr_param_class({name: 'Status', index: 0x5001, sub: 1}))
            control_body.append(table)

            var start_button = ($(`<input type="submit" value="${l100n.localize_string("ua_start")}" id="start_button">`))
            $(document).on('click', '#start_button', function()
            {
                console.log('start_button')
                var query = `/set_od_data.form?0x5002_1=1`;
                button_command_xhr.open('GET', query, true);
                button_command_xhr.send();
            })

            var stop_button = ($(`<input type="submit" value="${l100n.localize_string("ua_stop")}" id="stop_button">`))
            $(document).on('click', '#stop_button', function()
            {
                console.log('stop_button')
                var query = `/set_od_data.form?0x5002_1=2`;
                button_command_xhr.open('GET', query, true);
                button_command_xhr.send();
            })
            
            control_body.append(start_button)
            control_body.append(stop_button)
            $("#app_sw_div").append(control_header).append(control_body)

            var user_page = $('<div>')
            user_page.load("app_sw.html")
            $("#app_sw_div").append(user_page)
        }
    }

    get_status_xhr.onreadystatechange = function()
    {
        //console.log(get_status_xhr.readyState);
        if (get_status_xhr.readyState == 4)
        {
            if (get_status_xhr.status == 200)
            {
                status_ready();
            }
            else
            {
                alert("Проверьте соединение с контроллером...");
            }
        }
    }

    function get_response_values(xhr)
    {
        var response_values = [];
        var responseLines = xhr.responseText.split('\n');
        var responseLine = responseLines[0];
        //console.log("responseLine:"+responseLine);
        /*if ((responseLines[1].search( />>>ERROR<<</i ) != -1) || (responseLines[1].search( /!!!ERROR!!!/i ) != -1))
        {
            alert('Ошибка в ответе с сервера:' + responseLine);
        }*/

        response_values = responseLine.split('&#&');
        response_values.pop();
        //console.log('response_values: ' + response_values);
        return response_values;
    }
}
